/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.BackEndManager;
import jade.core.BaseService;
import jade.core.GenericCommand;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPPeer;
import jade.imtp.leap.JICP.PDPContextManager;
import jade.imtp.leap.JICP.ProtocolManager;
import jade.imtp.leap.TransportProtocol;
import jade.imtp.leap.nio.BEManagementHelper;
import jade.imtp.leap.nio.NIOJICPConnection;
import jade.imtp.leap.nio.NIOMediator;
import jade.imtp.leap.nio.PacketIncompleteException;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class BEManagementService
extends BaseService {
    public static final String NAME = "BEManagement";
    private static final String PREFIX = "jade_imtp_leap_nio_BEManagementService_";
    private static final int DEFAULT_PORT = 2099;
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final int INIT_STATE = 0;
    private static final int ACTIVE_STATE = 1;
    private static final int TERMINATING_STATE = 2;
    private static final int TERMINATED_STATE = 3;
    private static final int ERROR_STATE = -1;
    public static final String INCOMING_CONNECTION = "Incoming-Connection";
    private static final String[] OWNED_COMMANDS = new String[]{"Incoming-Connection"};
    private Hashtable servers = new Hashtable(2);
    private Ticker myTicker;
    private ServiceHelper myHelper;
    private Vector maliciousAddresses = new Vector();
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    static /* synthetic */ Class class$jade$imtp$leap$nio$NIOBEDispatcher;

    public String getName() {
        String className = this.getClass().getName();
        return className.substring(0, className.indexOf("Service"));
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        BackEndManager.getInstance(p);
    }

    public void boot(Profile p) throws ServiceException {
        String defaultServerIDs = PREFIX.substring(0, PREFIX.length() - 1);
        String serverIDs = p.getParameter("jade_imtp_leap_nio_BEManagementService_servers", defaultServerIDs);
        Vector v = this.parseStringList(serverIDs, ';');
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            try {
                IOEventServer srv = new IOEventServer();
                srv.init(id, p);
                this.servers.put(id, srv);
                srv.activate();
            }
            catch (Throwable t) {
                this.myLogger.log(Logger.WARNING, "Error activating IOEventServer " + id + ". " + t);
                t.printStackTrace();
            }
        }
        if (this.servers.size() == 0) {
            throw new ServiceException("NO IO-Event-Server active");
        }
        long tickTime = 30000L;
        try {
            tickTime = Long.parseLong(p.getParameter("jade_imtp_leap_nio_BEManagementService_ticktime", null));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.myTicker = new Ticker(tickTime);
        this.myTicker.start();
    }

    public void shutdown() {
        if (this.myTicker != null) {
            this.myTicker.shutdown();
        }
        Object[] ss = this.servers.values().toArray();
        int i = 0;
        while (i < ss.length) {
            ((IOEventServer)ss[i]).shutdown();
            ++i;
        }
    }

    public ServiceHelper getHelper(Agent a) {
        if (this.myHelper == null) {
            this.myHelper = new BEManagementHelperImpl();
        }
        return this.myHelper;
    }

    private void mergeProperties(Properties p1, Properties p2) {
        Enumeration<?> e = p2.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            p1.setProperty(key, p2.getProperty(key));
        }
    }

    private void waitABit(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException ie) {}
    }

    private Vector parseStringList(String strList, char separator) {
        Vector<String> elements = new Vector<String>();
        if (strList != null && !strList.equals("") && !strList.equals("null")) {
            char[] chars = new char[strList.length()];
            strList.getChars(0, strList.length(), chars, 0);
            String tmp = null;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c != separator) {
                    sb.append(c);
                } else {
                    tmp = sb.toString().trim();
                    if (tmp.length() > 0) {
                        elements.addElement(tmp);
                    }
                    sb = new StringBuffer();
                }
                ++i;
            }
            tmp = sb.toString().trim();
            if (tmp.length() > 0) {
                elements.addElement(tmp);
            }
        }
        return elements;
    }

    private final void checkAddress(SocketChannel sc) throws JADESecurityException {
        Socket s = sc.socket();
        InetAddress address = s.getInetAddress();
        if (this.maliciousAddresses.contains(address)) {
            try {
                sc.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new JADESecurityException(address.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BEManagementHelperImpl
    implements BEManagementHelper {
        private BEManagementHelperImpl() {
        }

        public void init(Agent a) {
        }

        public String getProperty(String containerName, String key) {
            Properties pp;
            String value = null;
            NIOMediator mediator = this.findMediatorGlobally(containerName);
            if (mediator != null && (pp = mediator.getProperties()) != null) {
                value = pp.getProperty(key);
            }
            return value;
        }

        private NIOMediator findMediatorGlobally(String id) {
            Object[] ss = BEManagementService.this.servers.values().toArray();
            int i = 0;
            while (i < ss.length) {
                NIOMediator m = ((IOEventServer)ss[i]).getFromID(id);
                if (m != null) {
                    return m;
                }
                ++i;
            }
            return null;
        }
    }

    private class Ticker
    extends Thread {
        private long period;
        private boolean active = false;

        private Ticker(long period) {
            this.period = period;
        }

        public void start() {
            this.active = true;
            this.setName("BEManagementService-ticker");
            super.start();
        }

        public void run() {
            while (this.active) {
                try {
                    Thread.sleep(this.period);
                    long currentTime = System.currentTimeMillis();
                    Object[] ss = BEManagementService.this.servers.values().toArray();
                    int i = 0;
                    while (i < ss.length) {
                        ((IOEventServer)ss[i]).tick(currentTime);
                        ++i;
                    }
                }
                catch (Throwable t) {
                    if (!this.active) continue;
                    BEManagementService.this.myLogger.log(Logger.WARNING, "BEManagementService-Ticker: Unexpected exception " + t);
                }
            }
        }

        public void shutdown() {
            this.active = false;
            this.interrupt();
        }
    }

    private class LoopManager
    implements Runnable {
        private int myIndex;
        private String displayId;
        private int state = 0;
        private Selector mySelector;
        private Thread myThread;
        private IOEventServer myServer;
        private boolean pendingChannelPresent = false;
        private List pendingChannels = new ArrayList();

        public LoopManager(IOEventServer server, int index) {
            this.myServer = server;
            this.myIndex = index;
            String id = this.myServer.getID();
            this.displayId = "BEManagementService" + (BEManagementService.PREFIX.startsWith(id) ? "" : "-" + id);
            try {
                this.mySelector = Selector.open();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public void start() {
            this.state = 1;
            String id = this.myServer.getID();
            String serverId = BEManagementService.PREFIX.startsWith(id) ? "" : "-" + id;
            this.myThread = new Thread(this);
            this.myThread.setName(this.displayId + "-T" + this.myIndex);
            this.myThread.start();
        }

        public void stop() {
            this.state = 2;
            this.mySelector.wakeup();
        }

        public void join() throws InterruptedException {
            this.myThread.join();
        }

        public void run() {
            while (this.state == 1) {
                int n;
                block9: {
                    n = 0;
                    try {
                        n = this.mySelector.select();
                    }
                    catch (NullPointerException npe) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myServer.getLogPrefix() + "NullPointerException in select. Ignore and retry.");
                        continue;
                    }
                    catch (Exception e) {
                        if (this.state != 1) break block9;
                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myServer.getLogPrefix() + "Error selecting next IO event. " + e);
                        e.printStackTrace();
                        this.state = -1;
                    }
                }
                if (this.state != 1) continue;
                if (n > 0) {
                    Set<SelectionKey> keys = this.mySelector.selectedKeys();
                    Iterator<SelectionKey> it = keys.iterator();
                    while (it.hasNext()) {
                        SelectionKey key = it.next();
                        if ((key.readyOps() & 0x10) != 0) {
                            this.handleAcceptOp(key);
                        } else if ((key.readyOps() & 1) != 0) {
                            this.handleReadOp(key);
                        }
                        it.remove();
                    }
                }
                this.handlePendingChannels();
            }
            this.state = 3;
        }

        private final void handleAcceptOp(SelectionKey key) {
            try {
                SocketChannel sc = ((ServerSocketChannel)key.channel()).accept();
                BEManagementService.this.checkAddress(sc);
                sc.configureBlocking(false);
                LoopManager lm = this.myServer.getLooper();
                lm.register(sc);
            }
            catch (JADESecurityException jse) {
                BEManagementService.this.myLogger.log(Logger.WARNING, this.myServer.getLogPrefix() + "Connection attempt from malicious address " + jse.getMessage());
            }
            catch (Exception e) {
                BEManagementService.this.myLogger.log(Logger.WARNING, this.myServer.getLogPrefix() + "Error accepting incoming connection. " + e);
                e.printStackTrace();
            }
        }

        private final void handleReadOp(SelectionKey key) {
            KeyManager mgr = (KeyManager)key.attachment();
            if (mgr == null) {
                mgr = new KeyManager(key, this.myServer.createConnection(key), this.myServer);
                key.attach(mgr);
            }
            mgr.read();
        }

        private final synchronized void register(SocketChannel sc) {
            this.pendingChannels.add(sc);
            this.pendingChannelPresent = true;
            this.mySelector.wakeup();
        }

        private final synchronized void handlePendingChannels() {
            if (this.pendingChannelPresent) {
                int i = 0;
                while (i < this.pendingChannels.size()) {
                    SocketChannel sc = (SocketChannel)this.pendingChannels.get(i);
                    try {
                        sc.register(this.mySelector, 1);
                    }
                    catch (Exception e) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myServer.getLogPrefix() + "Error registering socket channel for asynchronous IO. " + e);
                        e.printStackTrace();
                    }
                    ++i;
                }
                this.pendingChannels.clear();
                this.pendingChannelPresent = false;
            }
        }

        public final Selector getSelector() {
            return this.mySelector;
        }

        public final int size() {
            return this.mySelector.keys().size();
        }
    }

    private class KeyManager {
        private SelectionKey key;
        private Connection connection;
        private NIOMediator mediator;
        private IOEventServer server;

        public KeyManager(SelectionKey k, Connection c, IOEventServer s) {
            this.key = k;
            this.connection = c;
            this.server = s;
        }

        public final NIOMediator getMediator() {
            return this.mediator;
        }

        public final void setMediator(NIOMediator m) {
            this.mediator = m;
        }

        public final Connection getConnection() {
            return this.connection;
        }

        public final SelectionKey getKey() {
            return this.key;
        }

        public final void read() {
            try {
                JICPPacket pkt = this.connection.readPacket();
                this.server.servePacket(this, pkt);
            }
            catch (PacketIncompleteException pie) {
            }
            catch (Exception e) {
                this.server.serveException(this, e);
            }
        }
    }

    private class IOEventServer
    implements PDPContextManager,
    PDPContextManager.Listener,
    JICPMediatorManager {
        private String myID;
        private String myLogPrefix;
        private int state = 0;
        private ServerSocketChannel mySSChannel;
        private int mediatorCnt = 1;
        private Hashtable mediators = new Hashtable();
        private Vector deregisteredMediators = new Vector();
        private String host;
        private int port;
        private Properties leapProps = new Properties();
        private PDPContextManager myPDPContextManager;
        private TransportProtocol myProtocol;
        private ConnectionFactory myConnectionFactory;
        private LoopManager[] loopers;

        private IOEventServer() {
        }

        public void init(String id, Profile p) {
            this.myID = id;
            this.myLogPrefix = BEManagementService.PREFIX.startsWith(this.myID) ? "" : "Server " + this.myID + ": ";
            this.host = p.getParameter(id + '_' + "local-host", null);
            this.port = 2099;
            String strPort = p.getParameter(id + '_' + "local-port", this.myID);
            try {
                this.port = Integer.parseInt(strPort);
            }
            catch (Exception e) {
                // empty catch block
            }
            String protoManagerClass = p.getParameter(id + '_' + "protocol", null);
            ProtocolManager pm = null;
            try {
                pm = (ProtocolManager)Class.forName(protoManagerClass).newInstance();
            }
            catch (Exception e) {
                pm = new JICPPeer();
            }
            this.myProtocol = pm.getProtocol();
            this.myConnectionFactory = pm.getConnectionFactory();
            String fileName = p.getParameter(id + '_' + "leap-property-file", "leap.properties");
            try {
                this.leapProps.load(fileName);
            }
            catch (Exception e) {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Can't read LEAP property file " + fileName + ". Keep default. [" + e + "]");
            }
            this.leapProps.setProperty("jade_core_BackEndContainer_usebemanager", "true");
            String pdpContextManagerClass = this.leapProps.getProperty("pdp-context-manager");
            if (pdpContextManagerClass != null) {
                try {
                    BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "Loading PDPContextManager of class " + pdpContextManagerClass);
                    this.myPDPContextManager = (PDPContextManager)Class.forName(pdpContextManagerClass).newInstance();
                    this.myPDPContextManager.init(this.leapProps);
                    this.myPDPContextManager.registerListener(this);
                }
                catch (Throwable t) {
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Cannot load PDPContext manager " + pdpContextManagerClass);
                    t.printStackTrace();
                    this.myPDPContextManager = null;
                }
            } else {
                this.myPDPContextManager = this;
            }
            int poolSize = 5;
            String strPoolSize = p.getParameter(id + '_' + "poolsize", null);
            try {
                poolSize = Integer.parseInt(strPoolSize);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.loopers = new LoopManager[poolSize];
            int i = 0;
            while (i < this.loopers.length) {
                this.loopers[i] = new LoopManager(this, i);
                ++i;
            }
        }

        public synchronized void activate() throws Throwable {
            if (BEManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Opening server socket channel.");
            }
            this.mySSChannel = ServerSocketChannel.open();
            this.mySSChannel.configureBlocking(false);
            if (BEManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Binding server socket to." + this.host + ":" + this.port);
            }
            ServerSocket ss = this.mySSChannel.socket();
            InetSocketAddress addr = null;
            if (this.host != null) {
                addr = new InetSocketAddress(this.host, this.port);
            } else {
                addr = new InetSocketAddress(this.port);
                this.host = Profile.getDefaultNetworkName();
            }
            ss.bind(addr);
            if (BEManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Registering for asynchronous IO events.");
            }
            this.mySSChannel.register(this.getLooper().getSelector(), 16);
            BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "Ready to accept I/O events on address " + this.myProtocol.buildAddress(this.host, String.valueOf(this.port), null, null));
            int i = 0;
            while (i < this.loopers.length) {
                this.loopers[i].start();
                ++i;
            }
        }

        public int getLocalPort() {
            return this.mySSChannel.socket().getLocalPort();
        }

        public String getLocalHost() {
            return this.host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void shutdown() {
            if (BEManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Shutting down...");
            }
            try {
                if (this.mySSChannel != null) {
                    this.mySSChannel.close();
                }
                if (this.loopers != null) {
                    int i = 0;
                    while (i < this.loopers.length) {
                        this.loopers[i].stop();
                        this.loopers[i].join();
                        ++i;
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            Hashtable hashtable = this.mediators;
            synchronized (hashtable) {
                Iterator it = this.mediators.values().iterator();
                while (it.hasNext()) {
                    NIOMediator m = (NIOMediator)it.next();
                    m.kill();
                }
            }
            this.mediators.clear();
        }

        final String getID() {
            return this.myID;
        }

        final String getLogPrefix() {
            return this.myLogPrefix;
        }

        final LoopManager getLooper() {
            int minSize = 999999;
            int index = -1;
            int i = 0;
            while (i < this.loopers.length) {
                int size = this.loopers[i].size();
                if (size < minSize) {
                    minSize = size;
                    index = i;
                }
                ++i;
            }
            return this.loopers[index];
        }

        final Connection createConnection(SelectionKey key) {
            return new NIOJICPConnection(key);
        }

        public void servePacket(KeyManager mgr, JICPPacket pkt) {
            long end2;
            boolean closeConnection;
            JICPPacket reply;
            Connection connection;
            int port;
            InetAddress address;
            long start;
            block37: {
                start = System.currentTimeMillis();
                SelectionKey key = mgr.getKey();
                SocketChannel sc = (SocketChannel)key.channel();
                Socket s = sc.socket();
                address = s.getInetAddress();
                port = s.getPort();
                connection = mgr.getConnection();
                NIOMediator mediator = mgr.getMediator();
                reply = null;
                closeConnection = mediator == null;
                byte type = pkt.getType();
                String recipientID = pkt.getRecipientID();
                try {
                    switch (type) {
                        case 21: {
                            if (BEManagementService.this.myLogger.isLoggable(Logger.INFO)) {
                                BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "GET_ADDRESS request received from " + address + ":" + port);
                            }
                            reply = new JICPPacket(21, 0, address.getHostAddress().getBytes());
                            break;
                        }
                        case 22: {
                            if (mediator == null) {
                                NIOMediator old;
                                if (BEManagementService.this.myLogger.isLoggable(Logger.INFO)) {
                                    BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "CREATE_MEDIATOR request received from " + address + ":" + port);
                                }
                                Properties p = FrontEndStub.parseCreateMediatorRequest(new String(pkt.getData()));
                                p.setProperty("frontendhost", address.getHostAddress());
                                String owner = p.getProperty("owner");
                                if (BEManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                                    BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Owner = " + owner);
                                }
                                try {
                                    Properties pdpContextInfo = this.myPDPContextManager.getPDPContextInfo(address, owner);
                                    BEManagementService.this.mergeProperties(p, pdpContextInfo);
                                }
                                catch (JADESecurityException jse) {
                                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Security attack! CREATE_MEDIATOR request from non authorized address: " + address);
                                    reply = new JICPPacket("Not-authorized", jse);
                                    break;
                                }
                                String id = p.getProperty("mediator-id");
                                String msisdn = p.getProperty("msisdn");
                                if (id != null) {
                                    if (msisdn != null && !msisdn.equals(id)) {
                                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Security attack! CREATE_MEDIATOR request with mediator-id != MSISDN. Address is: " + address);
                                        reply = new JICPPacket("Not-authorized", null);
                                        break;
                                    }
                                    p.setProperty("jade_core_BackEndContainer_resynch", "true");
                                } else {
                                    id = msisdn;
                                    if (id == null) {
                                        id = "BE-" + this.getLocalHost() + '_' + this.getLocalPort() + '-' + String.valueOf(this.mediatorCnt++);
                                    }
                                }
                                if (id.equals(msisdn) && (old = (NIOMediator)this.mediators.get(id)) != null) {
                                    BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "Replacing old mediator " + id);
                                    old.kill();
                                    BEManagementService.this.waitABit(1000L);
                                }
                                closeConnection = !(mediator = this.startMediator(id, p)).handleIncomingConnection(connection, pkt, address, port);
                                this.mediators.put(mediator.getID(), mediator);
                                if (!closeConnection) {
                                    mgr.setMediator(mediator);
                                }
                                p.setProperty("mediator-id", mediator.getID());
                                p.setProperty("local-host", address.getHostAddress());
                                String replyMsg = FrontEndStub.encodeCreateMediatorResponse(p);
                                reply = new JICPPacket(1, 0, replyMsg.getBytes());
                                reply.setSessionID((byte)31);
                                break;
                            }
                            BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "CREATE_MEDIATOR request received on a connection already linked to an existing mediator");
                            reply = new JICPPacket("Unexpected packet type", null);
                            break;
                        }
                        case 23: {
                            if (mediator == null) {
                                if (BEManagementService.this.myLogger.isLoggable(Logger.INFO)) {
                                    BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "CONNECT_MEDIATOR request received from " + address + ":" + port + ". ID=" + recipientID);
                                }
                                if ((mediator = this.getFromID(recipientID)) != null && mediator.getID() != null) {
                                    boolean bl = closeConnection = !mediator.handleIncomingConnection(connection, pkt, address, port);
                                    if (!closeConnection) {
                                        mgr.setMediator(mediator);
                                    }
                                    reply = new JICPPacket(1, 0, address.getHostAddress().getBytes());
                                    break;
                                }
                                BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Mediator " + recipientID + " not found");
                                reply = new JICPPacket("Not-found", null);
                                break;
                            }
                            BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "CONNECT_MEDIATOR request received on a connection already linked to an existing mediator");
                            reply = new JICPPacket("Unexpected packet type", null);
                            break;
                        }
                        default: {
                            if (mediator == null) {
                                mediator = this.getFromID(recipientID);
                            }
                            if (mediator != null) {
                                if (BEManagementService.this.myLogger.isLoggable(Logger.FINEST)) {
                                    BEManagementService.this.myLogger.log(Logger.FINEST, this.myLogPrefix + "Passing packet of type " + type + " to mediator " + mediator.getID());
                                }
                                reply = mediator.handleJICPPacket(connection, pkt, address, port);
                                break;
                            }
                            BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "No mediator for incoming packet of type " + type);
                            if (type == 0) {
                                reply = new JICPPacket("Not-found", null);
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Error handling incoming packet. " + e);
                    e.printStackTrace();
                    if (type != 0 && type != 22 && type != 22 && type != 21) break block37;
                    reply = new JICPPacket("Unexpected error", e);
                }
            }
            if (reply != null) {
                try {
                    connection.writePacket(reply);
                }
                catch (IOException ioe) {
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Communication error writing return packet to " + address + ":" + port + " [" + ioe + "]");
                    closeConnection = true;
                }
            } else {
                closeConnection = false;
            }
            if (closeConnection) {
                try {
                    if (BEManagementService.this.myLogger.isLoggable(Logger.FINEST)) {
                        BEManagementService.this.myLogger.log(Logger.FINEST, this.myLogPrefix + "Closing connection with " + address + ":" + port);
                    }
                    connection.close();
                }
                catch (IOException io) {
                    if (BEManagementService.this.myLogger.isLoggable(Logger.WARNING)) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "I/O error while closing connection with " + address + ":" + port);
                    }
                    io.printStackTrace();
                }
            }
            if ((end2 = System.currentTimeMillis()) - start > 100L) {
                System.out.println("Serve time = " + (end2 - start));
            }
        }

        public void serveException(KeyManager mgr, Exception e) {
            Connection connection = mgr.getConnection();
            NIOMediator mediator = mgr.getMediator();
            if (mediator != null) {
                mediator.handleConnectionError(connection, e);
            } else {
                SelectionKey key = mgr.getKey();
                SocketChannel sc = (SocketChannel)key.channel();
                Socket s = sc.socket();
                InetAddress address = s.getInetAddress();
                int port = s.getPort();
                BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Exception reading incoming packet from " + address + ":" + port + " [" + e + "]");
            }
            try {
                connection.close();
            }
            catch (Exception ex) {}
        }

        public NIOMediator getFromID(String id) {
            if (id != null) {
                return (NIOMediator)this.mediators.get(id);
            }
            return null;
        }

        public void deregisterMediator(String id) {
            if (BEManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Deregistering mediator " + id);
            }
            this.deregisteredMediators.add(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tick(long currentTime) {
            Hashtable hashtable = this.mediators;
            synchronized (hashtable) {
                Iterator it = this.mediators.values().iterator();
                while (it.hasNext()) {
                    NIOMediator m = (NIOMediator)it.next();
                    m.tick(currentTime);
                }
            }
            Object[] dms = null;
            Vector vector = this.deregisteredMediators;
            synchronized (vector) {
                dms = this.deregisteredMediators.toArray();
                this.deregisteredMediators.clear();
            }
            int i = 0;
            while (i < dms.length) {
                Hashtable hashtable2 = this.mediators;
                synchronized (hashtable2) {
                    NIOMediator m = (NIOMediator)this.mediators.remove(dms[i]);
                    if (m.getID() != null) {
                        this.mediators.put(m.getID(), m);
                    }
                }
                ++i;
            }
        }

        public Properties getPDPContextInfo(InetAddress addr, String owner) throws JADESecurityException {
            GenericCommand cmd = new GenericCommand(BEManagementService.INCOMING_CONNECTION, BEManagementService.this.getName(), null);
            cmd.addParam(this.myID);
            cmd.addParam(addr);
            cmd.addParam(owner);
            try {
                Object ret;
                if (BEManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                    BEManagementService.this.myLogger.log(Logger.FINE, this.myLogPrefix + "Issuing command " + BEManagementService.INCOMING_CONNECTION);
                }
                if ((ret = BEManagementService.this.submit(cmd)) != null) {
                    if (ret instanceof Properties) {
                        if (BEManagementService.this.myLogger.isLoggable(Logger.FINER)) {
                            BEManagementService.this.myLogger.log(Logger.FINER, this.myLogPrefix + "PDPContextProperties for address " + addr + " owner " + owner + " = " + ret);
                        }
                        return (Properties)ret;
                    }
                    if (ret instanceof JADESecurityException) {
                        if (BEManagementService.this.myLogger.isLoggable(Logger.FINER)) {
                            BEManagementService.this.myLogger.log(Logger.FINER, this.myLogPrefix + "Address " + addr + " owner " + owner + " not authenticated.");
                        }
                        throw (JADESecurityException)ret;
                    }
                    if (ret instanceof Throwable) {
                        if (BEManagementService.this.myLogger.isLoggable(Logger.FINER)) {
                            BEManagementService.this.myLogger.log(Logger.FINER, this.myLogPrefix + "Error retrieving PDPContextPropert for address " + addr + " owner " + owner + ". " + ret);
                        }
                        ((Throwable)ret).printStackTrace();
                        throw new JADESecurityException(((Throwable)ret).getMessage());
                    }
                }
                return new Properties();
            }
            catch (ServiceException se) {
                se.printStackTrace();
                return null;
            }
        }

        public void init(Properties pp) {
        }

        public void registerListener(PDPContextManager.Listener l) {
        }

        public void handlePDPContextClosed(String id) {
        }

        protected NIOMediator startMediator(String id, Properties p) throws Exception {
            String className = p.getProperty("mediator-class");
            if (className == null) {
                className = (class$jade$imtp$leap$nio$NIOBEDispatcher == null ? (class$jade$imtp$leap$nio$NIOBEDispatcher = BEManagementService.class$("jade.imtp.leap.nio.NIOBEDispatcher")) : class$jade$imtp$leap$nio$NIOBEDispatcher).getName();
            }
            NIOMediator m = (NIOMediator)Class.forName(className).newInstance();
            BEManagementService.this.mergeProperties(p, this.leapProps);
            if (BEManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Initializing mediator " + id + " with properties " + p);
            }
            m.init(this, id, p);
            return m;
        }
    }
}

